
//  (C) Copyright Edward Diener 2011
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#if !defined(TTI_MF_TEMPLATE_PARAMS_HPP)
#define TTI_MF_TEMPLATE_PARAMS_HPP

#include <boost/config.hpp>
#include <boost/mpl/apply.hpp>
#include <boost/mpl/identity.hpp>
#include <boost/mpl/placeholders.hpp>
#include <boost/mpl/quote.hpp>

/*

  The succeeding comments in this file are in doxygen format.

*/

/** \file
*/

namespace boost
  {
  namespace tti
    {
  
  /// A metafunction which checks whether a class template with its parameters exists within an enclosing type.
  /**

      This metafunction takes its enclosing type as nullary metafunctions whose typedef 'type' member is the actual type used.
    
        template<class TTI_HasTemplateCheckParams,class TTI_T>
        struct mf_has_template_check_params
          {
          static const value = unspecified;
          typedef mpl::bool_<true-or-false> type;
          };

      The metafunction types and return:

        TTI_HasTemplateCheckParams = a Boost MPL lambda expression using the metafunction generated from either the BOOST_TTI_HAS_TEMPLATE_CHECK_PARAMS ( BOOST_TTI_TRAIT_HAS_TEMPLATE_CHECK_PARAMS ) 
                                     or BOOST_TTI_VM_HAS_TEMPLATE_CHECK_PARAMS ( BOOST_TTI_VM_TRAIT_HAS_TEMPLATE_CHECK_PARAMS ) macros.<br />
                                     The easiest way to generate the lambda expression is to use a Boost MPL placeholder expression of the form 'metafunction\<_\>'.
                                     You can also use a metafunction class generated by boost::mpl::quote1.
                      
        TTI_T           = The enclosing type as a nullary metafunction.
      
        returns = 'value' is true if the template exists within the enclosing type,
                  otherwise 'value' is false.
                          
        The template being introspected has the parameters specified by the macro metafunction passed as the first parameter
        to this metafunction.
          
  */
    template
      <
      class TTI_HasTemplateCheckParams,
      class TTI_T
      >
    struct mf_has_template_check_params :
      boost::mpl::apply
        <
        TTI_HasTemplateCheckParams,
        typename TTI_T::type
        >::type
      {
      };
    }
  }
  
#endif // TTI_MF_TEMPLATE_PARAMS_HPP
