
//  (C) Copyright Edward Diener 2011
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#if !defined(TTI_MF_STATIC_MEMBER_DATA_HPP)
#define TTI_MF_STATIC_MEMBER_DATA_HPP

#include <boost/config.hpp>
#include <boost/mpl/apply.hpp>
#include <boost/mpl/identity.hpp>
#include <boost/mpl/placeholders.hpp>
#include <boost/mpl/quote.hpp>
#include <boost/tti/gen/namespace_gen.hpp>
#include <boost/tti/detail/dtclass.hpp>

/*

  The succeeding comments in this file are in doxygen format.

*/

/** \file
*/

namespace boost
  {
  namespace tti
    {
  
    /// A metafunction which checks whether a static member data exists within an enclosing type.
    /**

        This metafunction takes its specific class types as nullary metafunctions whose typedef 'type' member is the actual type used.
    
        template<class TTI_HasStaticMemberData,class TTI_T,class TTI_Type>
        struct mf_has_member_data
          {
          static const value = unspecified;
          typedef mpl::bool_<true-or-false> type;
          };

        The metafunction types and return:

          TTI_HasStaticMemberData = a Boost MPL lambda expression using the metafunction generated from the BOOST_TTI_HAS_STATIC_MEMBER_DATA ( or BOOST_TTI_TRAIT_HAS_STATIC_MEMBER_DATA ) macro.<br />
                                   The easiest way to generate the lambda expression is to use a Boost MPL placeholder expression of the form 'metafunction\<_,_\>'.
                                   You can also use a metafunction class generated by boost::mpl::quote2.
                            
          TTI_T                   = the enclosing type as a nullary metafunction.
          
          TTI_Type                = the type of the static member data as a nullary metafunction.
                                    If the type is not a class type it may be passed as is.
      
          returns = 'value' is true if the static member data exists within the enclosing type,
                    otherwise 'value' is false.
                          
    */
    template
      <
      class TTI_HasStaticMemberData,
      class TTI_T,
      class TTI_Type
      >
    struct mf_has_static_member_data :
      boost::mpl::apply
        <
        TTI_HasStaticMemberData,
        typename TTI_T::type,
        typename BOOST_TTI_NAMESPACE::detail::tclass<TTI_Type>::type
        >::type 
      {
      };
    }
  }
  
#endif // TTI_MF_STATIC_MEMBER_DATA_HPP
