#include "stdafx.h"
#include <NadsDDSLib\NadsDDSLib.h>
#include <nadsddsimpl.h>


namespace NADSDDS {





CPublication::TRef 
CPublication::MakePublication(const std::string& name, int EID, size_t count, char cellType) {
	CPublication::TRef ret;

	switch (cellType)
	{
		case 'c':{
			unique_ptr<CCharPub> ptr = make_unique<CCharPub>(CCharPub::TRef(new CellPub<TypeChar>(name, DDSDomainRepo::GetDomain(0), count, EID)));
			return make_unique<CharPublication>(unique_ptr<	CCharPub>(std::move(ptr)));
		};
		case 'f': {
			unique_ptr<CFloatPub> ptr = make_unique<CFloatPub>(CFloatPub::TRef(new CellPub<TypeFloat>(name, DDSDomainRepo::GetDomain(0), count, EID)));
			return make_unique<FloatPublication>(unique_ptr<CFloatPub>(std::move(ptr)));
		};
		case 'd': {
			unique_ptr<CDoublePub> ptr = make_unique<CDoublePub>(make_unique<CellPub<TypeDouble>>(name, DDSDomainRepo::GetDomain(0), count, EID));
			return make_unique<DoublePublication>(unique_ptr<CDoublePub>(std::move(ptr)));
		};
		case 's': {
			unique_ptr<CShortPub> ptr = make_unique<CShortPub>(make_unique<CellPub<TypeShort>>(name, DDSDomainRepo::GetDomain(0), count, EID));
			return make_unique<ShortPublication>(unique_ptr<CShortPub>(std::move(ptr)));
		};
		case 'i': {
			unique_ptr<CIntPub> ptr = make_unique<CIntPub>(make_unique<CellPub<TypeInt>>(name, DDSDomainRepo::GetDomain(0), count, EID));
			return make_unique<IntPublication>(unique_ptr<CIntPub>(std::move(ptr)));

		};
	default:
		return ret;
		break;
	}
}
char* CPublication::asChar() { return nullptr; };
double* CPublication::asDouble() { return nullptr; };
float* CPublication::asFloat() { return nullptr; };
int* CPublication::asInt() { return nullptr; };
short* CPublication::asShort() { return nullptr; };
const std::string& CPublication::Name() { return GetPub()->_name;};
int CPublication::EID() {
	return GetPub()->eid();
}
void* CPublication::Raw() {
	auto ptr = GetPub();
	return ptr->Raw();
}
size_t CPublication::SizeInBytes() {
	return GetPub()->_sizeInBytes;
}
size_t CPublication::Count() {
	return GetPub()->_itemCount;
}

DoublePublication::DoublePublication(TDoublePubPtr&& ptr) :_ref(std::move(ptr)) {}

double* DoublePublication::asDouble() {
	return (double*)_ref->get()->Raw();
}
void DoublePublication::Publish() {
	(_ref)->get()->Send();
}
void DoublePublication::Set(const std::string& str){
    stringstream converter(str);
    double val;
    converter >> val;
    int size = Count();
    for (int i = 0; i < size; i++) {
        converter >> val;
        (*this)[i] = val;
     }
}

DoublePublication& DoublePublication::operator= (double val) {
	TypeDouble &dval = _ref->get()->data;
	dval.data()[0] = val;
	return *this;
}
double& DoublePublication::operator[] (size_t index) {
	static double nothing=0;
	TypeDouble &dval = _ref->get()->data;
	if (dval.data().size() > index) {
		return dval.data()[index];
	}
	return nothing;
}



CellRoot* DoublePublication::GetPub() {
	return _ref->get();
}

FloatPublication::FloatPublication(TFloatPubPtr&& ptr) :_ref(std::move(ptr)) {}
float* FloatPublication::asFloat() {
	return (float*)_ref->get()->Raw();
}
FloatPublication& FloatPublication::operator= (float val) {
	auto &dval = _ref->get()->data;
	dval.data()[0] = val;
	return *this;
}
float& FloatPublication::operator[] (size_t index) {
	static float nothing = 0;
	auto &dval = _ref->get()->data;
	if (dval.data().size() > index) {
		return dval.data()[index];
	}
	return nothing;
}

CellRoot* FloatPublication::GetPub() {
	return _ref->get();
}
void FloatPublication::Publish() {
	(_ref)->get()->Send();
}

void FloatPublication::Set(const std::string& str) {
    stringstream converter(str);
    float val;
    converter >> val;
    int size = Count();
    for (int i = 0; i < size; i++) {
        converter >> val;
        (*this)[i] = val;
    }
}

ShortPublication::ShortPublication(TShortPubPtr&& ptr) :_ref(std::move(ptr)) {}
short* ShortPublication::asShort() {
	return (short*)_ref->get()->Raw();
}
ShortPublication& ShortPublication::operator= (short val) {
	auto &dval = _ref->get()->data;
	dval.data()[0] = val;
	return *this;
}
short& ShortPublication::operator[] (size_t index) {
	static short nothing = 0;
	auto &dval = _ref->get()->data;
	if (dval.data().size() > index) {
		return dval.data()[index];
	}
	return nothing;
}

CellRoot* ShortPublication::GetPub() {
	return _ref->get();
}
void ShortPublication::Publish() {
	(_ref)->get()->Send();
}
void ShortPublication::Set(const std::string& str) {
    stringstream converter(str);
    short val;
    converter >> val;
    int size = Count();
    for (int i = 0; i < size; i++) {
        converter >> val;
        (*this)[i] = val;
    }
}

IntPublication::IntPublication(TIntPubPtr&& ptr) :_ref(std::move(ptr)) {}
int* IntPublication::asInt() {
	return (int*)_ref->get()->Raw();
}
IntPublication& IntPublication::operator= (int val) {
	auto &dval = _ref->get()->data;
	dval.data()[0] = val;
	return *this;
}
int& IntPublication::operator[] (size_t index) {
	static int nothing = 0;
	auto &dval = _ref->get()->data;
	if (dval.data().size() > index) {
		return dval.data()[index];
	}
	return nothing;
}
void IntPublication::Set(const std::string& str) {
    stringstream converter(str);
    int val;
    converter >> val;
    int size = Count();
    for (int i = 0; i < size; i++) {
        converter >> val;
        (*this)[i] = val;
    }
}

CellRoot* IntPublication::GetPub() {
	return _ref->get();
}

void IntPublication::Publish() {
	(_ref)->get()->Send();
}


CharPublication::CharPublication(TCharPubPtr&& ptr) :_ref(std::move(ptr)) {}
char* CharPublication::asChar() {
	return (char*)_ref->_ref->Raw();
}
CharPublication& CharPublication::operator= (const std::string& str) {
	auto &dval = _ref->get()->data;
	dval.data() = str;
	return *this;
}
char& CharPublication::operator[] (size_t index) {
	static char nothing = 0;
	auto &dval = _ref->_ref->data;
	if (dval.data().size() > index) {
		return dval.data()[index];
	}
	return nothing;
}

void CharPublication::Set(const std::string& str) {;
    int size = min(Count(), str.size());
    for (int i = 0; i < size; i++) {
        (*this)[i] = str[i];
    }
}

CellRoot* CharPublication::GetPub() {
	return _ref->_ref.get();
}

void CharPublication::Publish() {
	(_ref)->get()->Send();
}


size_t CSubscription::GetSizeInByes() {
	return GetCell()->_sizeInBytes;
}
void* CSubscription::GetRaw() {
	return GetCell()->Raw();
}



CSubscription::TRef 
CSubscription::MakeSubscription(const std::string& name, char cellType) {
	CSubscription::TRef ret;

	switch (cellType)
	{
	case 'c': {
		TCharSubscriptionRef ptr = make_unique<TCharSubscription>(name);
		ptr->Register();
		return CSubscription::TRef(new CCharSubscription(std::move(ptr)));
	};
	case 'f': {
		TFloatSubscriptionRef ptr = make_unique<TFloatSubscription>(name);
		ptr->Register();
		return CSubscription::TRef(new CFloatSubscription(std::move(ptr)));
	};
	case 'd': {
		TDoubleSubscriptionRef ptr = make_unique<TDoubleSubscription>(name);
		ptr->Register();
		return CSubscription::TRef(new CDoubleSubscription(std::move(ptr)));
	};
	case 's': {
		TShortSubscriptionRef ptr = make_unique<TShortSubscription>(name);
		ptr->Register();
		return CSubscription::TRef(new CShortSubscription(std::move(ptr)));
	};
	case 'i': {
		TIntSubscriptionRef ptr = make_unique<TIntSubscription>(name);
		ptr->Register();
		return CSubscription::TRef(new CIntSubscription(std::move(ptr)));

	};
	default:
		return ret;
		break;
	}
}

class CBPriv : public CStatePriv::Callback {
public:
	CBPriv(CState* par) :_par(par) {};
	CState* _par;
	void OnFrame(int num) {
		_par->NewFrame(num);
	}
	~CBPriv() {};
};

void CState::NewFrame(int frame) {
	for (auto cb : _Cbs) {
		auto sp = cb.lock();
		if (sp) {
			sp->OnFrame(frame);
		}
	}
	RemovedExpired<TCBWRefs, TCBWRef>(_Cbs);
}

int CState::GetFrame() {
	return CStatePriv::Get().GetFrame();
}
int CState::GetState() {
	return CStatePriv::Get().GetState();
}

void CState::Register(TCBRef ref) {
	_Cbs.push_back(ref);
	if (!_privCB) {
		_privCB = make_shared<CBPriv>(this);
		CStatePriv::Get().Register(_privCB);

	}
}


CState::CState() {

}
CState::~CState() {

}

namespace Info {
	void GetCellInfo(TCellInfoVec& cells) {
		DDSTopicInfo::Refresh();
		cells = DDSTopicInfo::GetTopics();
	}
}


}