#include "stdafx.h"



#include "nadsddsimpl.h"
using namespace std;
namespace NADSDDS {

	DDSDomainRepo::TRef DDSDomainRepo::DDSDomainRepo::_self;
	dds::domain::DomainParticipant&
		DDSDomainRepo::GetDomain(int id) {
		if (!_self) {
			auto ptr = new DDSDomainRepo();
			_self = TRef(ptr);
		}
		auto itr = _self->_DomainRefs.find(id);
		if (itr == _self->_DomainRefs.end()) 
		{
			_self->_DomainRefs[id] = make_unique<dds::domain::DomainParticipant>(id);
			return *(_self->_DomainRefs[id]);
		}
		return *(itr->second);
	}
	DDSDomainRepo::DDSDomainRepo() {
	};
	DDSTopicInfo::TRef DDSTopicInfo::_self;
	DDSTopicInfo* DDSTopicInfo::Get() {
		if (!_self) {
			auto ptr = new DDSTopicInfo();
			_self = TRef(ptr);
		}
		return _self.get();
	}

	void DDSTopicInfo::Refresh() {
		DDSTopicInfo::Get()->RefreshImpl();
	}
	void DDSTopicInfo::RefreshImpl() {
		//dds::domain::qos::DomainParticipantQos participant_qos = dds::core::QosProvider::Default().participant_qos();

		//dds::domain::qos::DomainParticipantFactoryQos qos;
		//qos << dds::core::policy::EntityFactory::ManuallyEnable();
		//dds::domain::DomainParticipant::participant_factory_qos(qos);

		//DomainParticipant participant(0, participant_qos);
		//DDSDomainRepo::GetDomain(0)
		GenericSubscriber subscriber(DDSDomainRepo::GetDomain(0), false);
		Sleep(100);
		//GenericSubscriber subscriber(participant, false);
		GenericSubscriber::TTopics topics;
		subscriber.list_topics(topics);

		_info.clear();
		for (auto& itr : topics) {
			if (itr.second == "TypeInt") {
				_info.push_back(std::make_tuple(itr.first,'i'));
			}
			if (itr.second == "TypeChar") {
				_info.push_back(std::make_tuple(itr.first, 'c'));
			}
			if (itr.second == "TypeFloat") {
				_info.push_back(std::make_tuple(itr.first, 'f'));
			}
			if (itr.second == "TypeShort") {
				_info.push_back(std::make_tuple(itr.first, 's'));
			}
			if (itr.second == "TypeDouble") {
				_info.push_back(std::make_tuple(itr.first, 'd'));
			}
		}
		
	}

	const DDSTopicInfo::TTypeVect& DDSTopicInfo::GetTopics() {
		return DDSTopicInfo::Get()->_info;
	}
	DDSTopicInfo::DDSTopicInfo() {}


	std::unique_ptr<CStatePriv> CStatePriv::_Ref;


	CStatePriv & CStatePriv::Get() {
		if (!_Ref) {
			_Ref = std::make_unique<CStatePriv>();
		}
		return *_Ref.get();
	}
	void CStatePriv::Register(CStatePriv::TCBRef reg) {
		_Cbs.push_back(reg);
	}
	void CStatePriv::Frame(int frameNum) {
		for (auto cb : _Cbs) {
			auto sp = cb.lock();
			if (sp) {
				sp->OnFrame(frameNum);
			}
		}
		RemovedExpired<TCBVec, TCBWRef>(_Cbs);
	}
	int CStatePriv::GetFrame() {
		return _frame;
	}
	int CStatePriv::GetState() {
		_StateSub->Swap();
		auto& buff = _StateSub->GetBuff();
		if (buff.size() > 0)
			return buff[0];
		return -1;

	}

	CStatePriv::CStatePriv() {
		_newFrameCb = make_shared<CStatePriv::OnNewFrame>(this);
		_FrameSub = std::make_unique<DataStream<TypeInt>>("Frame", &DDSDomainRepo::GetDomain(0), _newFrameCb);
		_StateSub = std::make_unique<TIntSubscription>("StateMode");
		_StateSub->Register();
	}
}