#pragma once

#include<string>
#include<memory>
#include<map>
#include<vector>
//////////////////////////////////////////////////////////////////////////////////////////////////
///
///
///
///
///
///
///
///
///
///
///


namespace NADSDDS {
	using namespace std;
	class CellRoot;

	class CFloatPub;
	class CCharPub;
	class CDoublePub;
	class CIntPub;
	class CShortPub;


	typedef unique_ptr< CellRoot>    TPubPtr;
	typedef unique_ptr<	CFloatPub>  TFloatPubPtr ; 
	typedef unique_ptr<	CCharPub>   TCharPubPtr;
	typedef unique_ptr<	CDoublePub> TDoublePubPtr;
	typedef unique_ptr<	CIntPub>    TIntPubPtr;
	typedef unique_ptr<	CShortPub>  TShortPubPtr;

	class CellRoot {
	public:
		CellRoot(int id) :_eid(id), _itemCount(0), _period(-1) {
		}
		virtual void* Raw() = 0;
		virtual void Send() = 0;
		virtual int& eid() = 0;
		int _eid;
		std::string _name;
		size_t _itemCount;
		size_t _sizeInBytes;
		int _period;

	};

	class CellInRoot {
	public:
		CellInRoot(const std::string& name) :_name(name),_eid(-1), _itemCount(0), _period(-1) {
		}
		virtual void* Raw() = 0;
		virtual int eid() = 0;
		int _eid;
		std::string _name;
		size_t _itemCount;
		size_t _sizeInBytes;
		int _period;

	};

	template<class T> class BufferedCellRoot: public CellInRoot {
	public:
		BufferedCellRoot(std::string name) : CellInRoot(name) {}
		vector<T>& operator()() {
			return _buffer;
		}
		virtual bool Swap() = 0;
		vector<T>& GetBuff() { return _buffer; }
		virtual void* Raw() { return _buffer.data(); }
	protected:
		vector<T> _buffer;
	};

	class CSubscription {
	public:
		typedef unique_ptr<CSubscription> TRef;
		TRef MakeSubscription(const std::string&, int EID, size_t count, char cellType);
		virtual const char* asChar() { return nullptr; };
		virtual const double* asDouble() { return nullptr; };
		virtual const float* asFloat() { return nullptr; };
		virtual const int* asInt() { return nullptr; };
		virtual const short* asShort() { return nullptr; };
		virtual void SwapBuffer() = 0;
	protected:
		virtual CellInRoot* GetCell() = 0;
	};

	class CFloatSubscription : public CSubscription {
	public:
		typedef unique_ptr<BufferedCellRoot<float>> TSubref;
		CFloatSubscription(TSubref&& sub) :_subsription(std::move(sub)) {};
		virtual const float* asFloat() override { return _subsription->GetBuff().data(); };
		std::vector<float>& operator()() { return _subsription->GetBuff(); };
		virtual void SwapBuffer() override { _subsription->Swap(); };
	protected:
		virtual CellInRoot* GetCell() override { return _subsription.get(); };
	private:
		TSubref _subsription;
	};

	//class CDoubleSubscrition : public CSubscription {
	//public:
	//	CDoubleSubscrition();
	//	std::vector<double>& operator()() { return _val->GetBuff(); };;
	//private:
	//	unique_ptr<BufferedCellRoot<double>>  _val;
	//};


	//class CIntSubscription : public CSubscription {
	//public:
	//	CIntSubscription();
	//	std::vector<int>& operator()() { return _val->GetBuff(); };
	//private:
	//	unique_ptr<BufferedCellRoot<int>> _val;
	//};

	//class CCharSubscription : public CSubscription {
	//public:
	//	CCharSubscription();
	//	std::vector<char>& operator()() { return _val->GetBuff(); };
	//private:
	//	unique_ptr<BufferedCellRoot<char>> _val;
	//};

	//class CShortSubscription : public CSubscription {
	//public:
	//	CShortSubscription();
	//	std::vector<short>& operator()() { return _val->GetBuff(); };
	//private:
	//	unique_ptr<BufferedCellRoot<short>> _val;
	//};


	class CPublication{
	public:
		typedef unique_ptr<CPublication> TRef;
		TRef MakePublication(const std::string&, int EID, size_t count, char cellType);
		virtual char* asChar();
		virtual double* asDouble();
		virtual float* asFloat();
		virtual int* asInt();
		virtual short* asShort();
		void* Raw();
		const std::string& Name();
		int EID();
		size_t SizeInBytes();
		size_t Count();
		void Publish();
	protected:
		virtual CellRoot* GetPub() = 0;
		CPublication() {};
	};

	class DoublePublication :public  CPublication {
	public:
		DoublePublication(TDoublePubPtr&&);
		virtual double* asDouble()override;
		DoublePublication& operator= (double);
		double& operator[] (size_t);
	private:
		virtual CellRoot* GetPub() override;
		TDoublePubPtr _ref;
	};

	class FloatPublication :public  CPublication {
	public:
		FloatPublication(TFloatPubPtr&&);
		virtual float* asFloat() override;
		FloatPublication& operator= (float);
		float& operator[] (size_t);
	private:
		virtual CellRoot* GetPub() override;
		TFloatPubPtr _ref;
	};

	class ShortPublication :public  CPublication {
	public:
		ShortPublication(TShortPubPtr&&);
		virtual short* asShort() override;
		ShortPublication& operator= (short);
		short& operator[] (size_t);
	private:
		virtual CellRoot* GetPub() override;
		TShortPubPtr _ref;
	};

	class IntPublication :public  CPublication {
	public:
		IntPublication(TIntPubPtr&&);
		virtual int* asInt() override;
		IntPublication& operator= (int);
		int& operator[] (size_t);
	private:
		virtual CellRoot* GetPub() override;
		TIntPubPtr _ref;
	};

	class CharPublication :public  CPublication {
	public:
		CharPublication(TCharPubPtr&&);
		virtual char* asChar() override;
		CharPublication& operator= (const std::string&);
		char& operator[] (size_t);
	private:
		virtual CellRoot* GetPub() override;
		TCharPubPtr _ref;
	};

}