#pragma once

#include<string>
#include<memory>
#include<map>
#include<vector>
//////////////////////////////////////////////////////////////////////////////////////////////////
///
///
///
///
///
///
///
///
///
///
///
#ifndef NO_AUTOLINK_NADS_DDS_LIB
#ifdef _MSC_VER
    #pragma comment(lib, "Ws2_32.lib")
	#ifdef _DEBUG
		#ifdef _X86_
			#ifndef NADSDDDS_DLL
				#pragma comment(lib,"NadsDDSLib_32ds.lib")
				#pragma comment(lib,"nddscpp2zd.lib")
				#pragma comment(lib,"nddsczd.lib")
				#pragma comment(lib,"nddscorezd.lib")
				#pragma comment(lib,"netapi32.lib")
				#pragma comment(lib,"advapi32.lib")
				#pragma comment(lib,"user32.lib")
			#endif
		#else
			#ifndef NADSDDDS_DLL
				#pragma comment(lib,"NadsDDSLib_64ds.lib")
				#pragma comment(lib,"nddscpp2zd.lib")
				#pragma comment(lib,"nddsczd.lib")
				#pragma comment(lib,"nddscorezd.lib")
				#pragma comment(lib,"netapi32.lib")
				#pragma comment(lib,"advapi32.lib")
				#pragma comment(lib,"user32.lib")
			#endif
		#endif // DEBUG
	#else
		#ifdef _X86_
			#ifndef NADSDDDS_DLL
				#pragma comment(lib,"NadsDDSLib_32s.lib")
				#pragma comment(lib,"nddscpp2z.lib")
				#pragma comment(lib,"nddscz.lib")
				#pragma comment(lib,"nddscorez.lib")
				#pragma comment(lib,"netapi32.lib")
				#pragma comment(lib,"advapi32.lib")
				#pragma comment(lib,"user32.lib")
			#endif
		#else
			#ifndef NADSDDDS_DLL
				#pragma comment(lib,"NadsDDSLib_64s.lib")
				#pragma comment(lib,"nddscpp2z.lib")
				#pragma comment(lib,"nddscz.lib")
				#pragma comment(lib,"nddscorez.lib")
				#pragma comment(lib,"netapi32.lib")
				#pragma comment(lib,"advapi32.lib")
				#pragma comment(lib,"user32.lib")
			#endif
		#endif // DEBUG
	#endif
#endif
#endif
namespace NADSDDS {
	using namespace std;
	class CellRoot;

	class CFloatPub;
	class CCharPub;
	class CDoublePub;
	class CIntPub;
	class CShortPub;


	typedef unique_ptr< CellRoot>    TPubPtr;
	typedef unique_ptr<	CFloatPub>  TFloatPubPtr ; 
	typedef unique_ptr<	CCharPub>   TCharPubPtr;
	typedef unique_ptr<	CDoublePub> TDoublePubPtr;
	typedef unique_ptr<	CIntPub>    TIntPubPtr;
	typedef unique_ptr<	CShortPub>  TShortPubPtr;

	class CellRoot {
	public:
		CellRoot(int id) :_eid(id), _itemCount(0), _period(-1) {
		}
		virtual void* Raw() = 0;
		virtual void Send() = 0;
		virtual int& eid() = 0;
		int _eid;
		std::string _name;
		size_t _itemCount;
		size_t _sizeInBytes;
		int _period;

	};

	class CellInRoot {
	public:
		CellInRoot(const std::string& name) :_name(name),_eid(-1), _itemCount(0), _period(-1), _sizeInBytes(0){
		}
		virtual void* Raw() = 0;
		virtual int eid() = 0;
		int _eid;
		std::string _name;
		size_t _itemCount;
		size_t _sizeInBytes;
		int _period;

	};

	template<class T> class BufferedCellRoot: public CellInRoot {
	public:
		BufferedCellRoot(std::string name) : CellInRoot(name) {}
		vector<T>& operator()() {
			return _buffer;
		}
		virtual bool Swap() = 0;
		vector<T>& GetBuff() { return _buffer; }
		size_t Size() { return _buffer.size(); }
		virtual void* Raw() { return _buffer.data(); }
	protected:
		vector<T> _buffer;
	};

	class CSubscription {
	public:
		typedef unique_ptr<CSubscription> TRef;
		static TRef MakeSubscription(const std::string&, char cellType);
		virtual const char* asChar() = 0; 
		virtual const double* asDouble() = 0;
		virtual const float* asFloat() = 0;
		virtual const int* asInt() = 0;
		virtual const short* asShort() = 0;
		virtual void SwapBuffer() = 0;
		size_t GetSizeInByes();
		void* GetRaw();
	protected:
		virtual CellInRoot* GetCell() = 0;
	};

	class CFloatSubscription : public CSubscription {
	public:
		typedef unique_ptr<BufferedCellRoot<float>> TSubref;
		CFloatSubscription(TSubref&& sub) :_subsription(std::move(sub)) {};
		virtual const float* asFloat() override { if (_subsription->Size() == 0) return nullptr;  return _subsription->GetBuff().data(); };
		virtual const char* asChar()  { return nullptr; };
		virtual const double* asDouble() { return nullptr; };
		virtual const int* asInt() { return nullptr; };
		virtual const short* asShort() { return nullptr; };

		std::vector<float>& operator()() { return _subsription->GetBuff(); };
		virtual void SwapBuffer() override { _subsription->Swap(); };
	protected:
		virtual CellInRoot* GetCell() override { return _subsription.get(); };
	private:
		TSubref _subsription;
	};

	class CIntSubscription : public CSubscription {
	public:
		typedef unique_ptr<BufferedCellRoot<int>> TSubref;
		CIntSubscription(TSubref&& sub) :_subsription(std::move(sub)) {};
		virtual const float* asFloat() override {return nullptr;};
		virtual const char* asChar() { return nullptr; };
		virtual const double* asDouble() { return nullptr; };
		virtual const int* asInt() { if (_subsription->Size() == 0) return nullptr;  return _subsription->GetBuff().data(); };
		virtual const short* asShort() { return nullptr; };

		std::vector<int>& operator()() { return _subsription->GetBuff(); };
		virtual void SwapBuffer() override { _subsription->Swap(); };
	protected:
		virtual CellInRoot* GetCell() override { return _subsription.get(); };
	private:
		TSubref _subsription;
	};


	class CDoubleSubscription : public CSubscription {
	public:
		typedef unique_ptr<BufferedCellRoot<double>> TSubref;
		CDoubleSubscription(TSubref&& sub) :_subsription(std::move(sub)) {};
		virtual const float* asFloat() override { return nullptr; };
		virtual const char* asChar() { return nullptr; };
		virtual const double* asDouble() { if (_subsription->Size() == 0) return nullptr;  return _subsription->GetBuff().data(); };
		virtual const int* asInt() { return nullptr; };
		virtual const short* asShort() { return nullptr; };

		std::vector<double>& operator()() { return _subsription->GetBuff(); };
		virtual void SwapBuffer() override { _subsription->Swap(); };
	protected:
		virtual CellInRoot* GetCell() override { return _subsription.get(); };
	private:
		TSubref _subsription;
	};

	class CCharSubscription : public CSubscription {
	public:
		typedef unique_ptr<BufferedCellRoot<char>> TSubref;
		CCharSubscription(TSubref&& sub) :_subsription(std::move(sub)) {};
		virtual const float* asFloat() override { return nullptr; };
		virtual const char* asChar() { if (_subsription->Size() == 0) return nullptr;  return _subsription->GetBuff().data(); }
		virtual const double* asDouble() { return nullptr; };
		virtual const int* asInt() { return nullptr; };
		virtual const short* asShort() { return nullptr; };

		std::vector<char>& operator()() { return _subsription->GetBuff(); };
		virtual void SwapBuffer() override { _subsription->Swap(); };
	protected:
		virtual CellInRoot* GetCell() override { return _subsription.get(); };
	private:
		TSubref _subsription;
	};


	class CShortSubscription : public CSubscription {
	public:
		typedef unique_ptr<BufferedCellRoot<short>> TSubref;
		CShortSubscription(TSubref&& sub) :_subsription(std::move(sub)) {};
		virtual const float* asFloat() override { return nullptr; };
		virtual const char* asChar() { return nullptr; }
		virtual const double* asDouble() { return nullptr; };
		virtual const int* asInt() { return nullptr; };
		virtual const short* asShort() { if (_subsription->Size() == 0) return nullptr;  return _subsription->GetBuff().data(); };

		std::vector<short>& operator()() { return _subsription->GetBuff(); };
		virtual void SwapBuffer() override { _subsription->Swap(); };
	protected:
		virtual CellInRoot* GetCell() override { return _subsription.get(); };
	private:
		TSubref _subsription;
	};


	//class CDoubleSubscrition : public CSubscription {
	//public:
	//	CDoubleSubscrition();
	//	std::vector<double>& operator()() { return _val->GetBuff(); };;
	//private:
	//	unique_ptr<BufferedCellRoot<double>>  _val;
	//};


	//class CIntSubscription : public CSubscription {
	//public:
	//	CIntSubscription();
	//	std::vector<int>& operator()() { return _val->GetBuff(); };
	//private:
	//	unique_ptr<BufferedCellRoot<int>> _val;
	//};

	//class CCharSubscription : public CSubscription {
	//public:
	//	CCharSubscription();
	//	std::vector<char>& operator()() { return _val->GetBuff(); };
	//private:
	//	unique_ptr<BufferedCellRoot<char>> _val;
	//};

	//class CShortSubscription : public CSubscription {
	//public:
	//	CShortSubscription();
	//	std::vector<short>& operator()() { return _val->GetBuff(); };
	//private:
	//	unique_ptr<BufferedCellRoot<short>> _val;
	//};


	class CPublication{
	public:
		typedef unique_ptr<CPublication> TRef;
		static TRef MakePublication(const std::string&, int EID, size_t count, char cellType);
		virtual char* asChar();
		virtual double* asDouble();
		virtual float* asFloat();
		virtual int* asInt();
		virtual short* asShort();
		void* Raw();
		const std::string& Name();
		int EID();
		size_t SizeInBytes();
		size_t Count();
		virtual void Publish() = 0 ;
        virtual void Set(const std::string&) =0;
	protected:
		virtual CellRoot* GetPub() = 0;
		CPublication() {};
	};

	class DoublePublication :public  CPublication {
	public:
		DoublePublication(TDoublePubPtr&&);
		virtual double* asDouble() override;
		DoublePublication& operator= (double);
		double& operator[] (size_t);
		virtual void Publish() override;
        virtual void Set(const std::string&) override;
	private:
		virtual CellRoot* GetPub() override;
		TDoublePubPtr _ref;
	};

	class FloatPublication :public  CPublication {
	public:
		FloatPublication(TFloatPubPtr&&);
		virtual float* asFloat() override;
		FloatPublication& operator= (float);
		float& operator[] (size_t);
		virtual void Publish() override;
        virtual void Set(const std::string&) override;
	private:
		virtual CellRoot* GetPub() override;
		TFloatPubPtr _ref;
	};

	class ShortPublication :public  CPublication {
	public:
		ShortPublication(TShortPubPtr&&);
		virtual short* asShort() override;
		ShortPublication& operator= (short);
		short& operator[] (size_t);
		virtual void Publish() override;
        virtual void Set(const std::string&) override;
	private:
		virtual CellRoot* GetPub() override;
		TShortPubPtr _ref;
	};

	class IntPublication :public  CPublication {
	public:
		IntPublication(TIntPubPtr&&);
		virtual int* asInt() override;
		IntPublication& operator= (int);
		int& operator[] (size_t);
		virtual void Publish() override;
        virtual void Set(const std::string&) override;
	private:
		virtual CellRoot* GetPub() override;
		TIntPubPtr _ref;
	};

	class CharPublication :public  CPublication {
	public:
		CharPublication(TCharPubPtr&&);
		virtual char* asChar() override;
		CharPublication& operator= (const std::string&);
		char& operator[] (size_t);
		virtual void Publish() override;
        virtual void Set(const std::string&) override;
	private:
		virtual CellRoot* GetPub() override;
		TCharPubPtr _ref;
	};

	namespace Info {
		typedef std::tuple<std::string, char> TCellInfo;
		typedef std::vector<TCellInfo> TCellInfoVec;
		void GetCellInfo(TCellInfoVec& cells);
	}
	class CBPriv;
	class CState {
	public:
		friend class CBPriv;
		class Callback {
		public:
			Callback() {};
			virtual void OnFrame(int frame) = 0;
		};
		typedef std::shared_ptr<Callback> TCBRef;
		typedef std::weak_ptr<Callback> TCBWRef;
		CState();
		~CState();
		int GetFrame();
		int GetState();
		void Register(TCBRef);
	protected:
		void NewFrame(int);
		typedef std::shared_ptr<CBPriv> TCBPrivRef;
		TCBPrivRef _privCB;
		typedef std::vector<TCBWRef> TCBWRefs;
		TCBWRefs _Cbs;
	};

}