#include "stdafx.h"
#include ".\include\NadsDDSLib\DDSSimClient.h"

namespace NDDSClient {
	using namespace std;
	CCellInputMap::CCellInputMap() {}


	void CCellInputMap::RegInpElem(std::string name, void *_pBuffer, const unsigned int _BufferSize, char _BufferType) {
		CCellInputMap::TCellRef ref = std::make_unique<CellInput>();
		ref->_sub = NADSDDS::CSubscription::MakeSubscription(name, _BufferType);
		ref->_size = _BufferSize;
		ref->_type = _BufferType;
		ref->_target = _pBuffer;
		_cellsIn[name] = std::move(ref);
	}
	
	void CCellInputMap::ReadInputElements() {
		for (auto& cell : _cellsIn) {
			auto& cellIn = cell.second;
			cellIn->_sub->SwapBuffer();
			size_t size = cellIn->_sub->GetSizeInByes();
			if (cellIn->_size == size) {
				void* ptr = cellIn->_sub->GetRaw();
				memcpy(cellIn->_target, ptr, size);
			}
		}
	}

	void CCellOutputMap::RegInpElem(std::string name, void *_pBuffer, const unsigned int _BufferSize, char _BufferType) {
		TCellRef ref = std::make_unique<CellOutput>();
		size_t elementSize = 0;
		switch (_BufferType) {
		case 'c':
			elementSize = 1;
			break;
		case 's':
			elementSize = 2;
			break;
		case 'f':
		case 'i':
			elementSize = 4;
			break;
		case 'd':
			elementSize = 8;
			break;
		}
		size_t cnt = _BufferSize / elementSize;
		ref->_sub = NADSDDS::CPublication::MakePublication(name, -1, cnt, _BufferType);
		ref->_size = _BufferSize;
		ref->_type = _BufferType;
		ref->_target = _pBuffer;
		_cellsOut[name] = std::move(ref);
	}
	
	void CCellOutputMap::WriteOutputElements() {
			for (auto& cell : _cellsOut) {
				auto& cellOut = cell.second;
				void* ptr = cellOut->_sub->Raw();
				memcpy(ptr, cellOut->_target, cellOut->_size);

				cellOut->_sub->Publish();
			}
	}

	void  DDSSimClient::RegisterStartup(DDSSimClient::TStartCBRef) {
	}


	void DDSSimClient::RegisterFrameCB(DDSSimClient::TFrameCBRef) {
	}
	DDSSimClient::DDSSimClient() : NADSDDS::CState::Callback(), _currentFrame(-1), _Started(false) {}

	 void 	DDSSimClient::OnFrame(int frame) {
		_currentFrame = frame;
		NADSDDS::CState cs;
		auto state = cs.GetState();
		if (!_Started) {
			return;
		}
		_map.ReadInputElements();
		if (_HeartBeat) {
			_HeartBeat->asShort()[0]++;
			_HeartBeat->Publish();
		}
		_omap.WriteOutputElements();
	}
	void DDSSimClient::StartUp() {

	}

	void  DDSSimClient::RegInputCell(const std::string& name, void* pnt, size_t size, char type) {
		_map.RegInpElem(name, pnt, size, type);
	}

	void  DDSSimClient::RegOutputCell(const std::string& name, void* pnt, size_t size, char type) {
		_omap.RegInpElem(name, pnt, size, type);
	}
	DDSSimClient::TRef DDSSimClient::Make(TFrameCBRef frame, TStartCBRef startup) {
		auto ptr = std::make_shared<DDSSimClient>();
		ptr->RegisterFrameCB(frame);
		ptr->RegisterStartup(startup);
		ptr->StartUp();
		ptr->_dds_state.Register(ptr);
	}
}