#include "stdafx.h"
#include ".\include\NadsDDSLib\DDSSimClient.h"
#include "apex_memmove.h"
namespace NDDSClient {
	using namespace std;
	CCellInputMap::CCellInputMap() {}


	void CCellInputMap::RegInpElem(std::string name, void *_pBuffer, const unsigned int _BufferSize, char _BufferType) {
		CCellInputMap::TCellRef ref = std::make_unique<CellInput>();
		ref->_sub = NADSDDS::CSubscription::MakeSubscription(name, _BufferType);
		ref->_size = _BufferSize;
		ref->_type = _BufferType;
		ref->_target = _pBuffer;
		_cellsIn[name] = std::move(ref);
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \fn void CCellInputMap::ReadInputElements()
	///
	/// \brief Memswap between registered cells, and user variables.
	///
	/// \author Simop
	/// \date 4/30/2019
	////////////////////////////////////////////////////////////////////////////////////////////////////

	void CCellInputMap::ReadInputElements() {
		for (auto& cell : _cellsIn) {
			auto& cellIn = cell.second;
			cellIn->_sub->SwapBuffer();
			size_t size = cellIn->_sub->GetSizeInByes();
			if (cellIn->_size == size) {
				void* ptr = cellIn->_sub->GetRaw();
				apex::memcpy(cellIn->_target, ptr, size);
			}
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \fn void CCellOutputMap::RegInpElem(std::string name, void *_pBuffer, const unsigned int _BufferSize, char _BufferType)
	///
	/// \brief Registers the inp element
	///
	/// Registers the DDS subscription, and saves the reference to user variable, when ReadInputElements this will
	/// copy the data from the registered user varaible to the publication.
 	///
	/// \author Simop
	/// \date 4/30/2019
	///
	/// \param 		    name	    The name.
	/// \param [in,out] _pBuffer    If non-null, the buffer.
	/// \param 		    _BufferSize Size of the buffer.
	/// \param 		    _BufferType Type of the buffer.
	////////////////////////////////////////////////////////////////////////////////////////////////////

	void CCellOutputMap::RegInpElem(std::string name, void *_pBuffer, const unsigned int _BufferSize, char _BufferType) {
		TCellRef ref = std::make_unique<CellOutput>();
		size_t elementSize = 0;
		switch (_BufferType) {
		case 'c':
			elementSize = 1;
			break;
		case 's':
			elementSize = 2;
			break;
		case 'f':
		case 'i':
			elementSize = 4;
			break;
		case 'd':
			elementSize = 8;
			break;
		}
		size_t cnt = _BufferSize / elementSize;
		ref->_sub = NADSDDS::CPublication::MakePublication(name, -1, cnt, _BufferType);
		ref->_size = _BufferSize;
		ref->_type = _BufferType;
		ref->_target = _pBuffer;
		_cellsOut[name] = std::move(ref);
	}
	
	void CCellOutputMap::WriteOutputElements() {
			for (auto& cell : _cellsOut) {
				auto& cellOut = cell.second;
				void* ptr = cellOut->_sub->Raw();
				memcpy(ptr, cellOut->_target, cellOut->_size);

				cellOut->_sub->Publish();
			}
	}

	void  DDSSimClient::RegisterStartup(DDSSimClient::TStartCBRef) {
	}


	void DDSSimClient::RegisterFrameCB(DDSSimClient::TFrameCBRef) {
	}
	DDSSimClient::DDSSimClient() : NADSDDS::CState::Callback(), _currentFrame(-1), _Started(false) {}

	 void 	DDSSimClient::OnFrame(int frame) {
		_currentFrame = frame;
		NADSDDS::CState cs;
		auto state = cs.GetState();
		if (!_Started) {
			return;
		}
		_map.ReadInputElements();
		if (_HeartBeat) {
			_HeartBeat->asShort()[0]++;
			_HeartBeat->Publish();
		}
		_omap.WriteOutputElements();
	}
	void DDSSimClient::StartUp() {

	}

	void  DDSSimClient::RegInputCell(const std::string& name, void* pnt, size_t size, char type) {
		_map.RegInpElem(name, pnt, size, type);
	}

	void  DDSSimClient::RegOutputCell(const std::string& name, void* pnt, size_t size, char type) {
		_omap.RegInpElem(name, pnt, size, type);
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \fn DDSSimClient::TRef DDSSimClient::Make(TFrameCBRef frame, TStartCBRef startup)
	///
	/// \brief Makes DDSSimClient + does startup sequence
	/// If this sim is operating you should be getting callback - only call this when you are 
	/// ready for the CBs
	///
	/// \author Simop
	/// \date 4/26/2019
	///
	/// \param frame   The frame.
	/// \param startup The startup.
	///
	/// \returns A DDSSimClient::TRef.
	////////////////////////////////////////////////////////////////////////////////////////////////////

	DDSSimClient::TRef DDSSimClient::Make(TFrameCBRef frame, TStartCBRef startup) {
		//this most likely should use a proxy obj so we can use make_shared
		auto ptr = DDSSimClient::TRef(new DDSSimClient()); 
		ptr->RegisterFrameCB(frame);
		ptr->RegisterStartup(startup);
		ptr->StartUp();
		ptr->_dds_state.Register(ptr);
		return ptr;
	}
}