#pragma once

#include <DaqIoLib.h>
class DaqPlayer
{
    typedef unsigned char            TDaqByte;
    typedef std::vector<int>         TIntVec;
    typedef std::vector<std::string> TStrVec;
    typedef std::vector<CDaqBuffer>  TDataVec;
    typedef std::vector<CDaqChannelInfo> TChanInfoVec;
    typedef std::unique_ptr<CDaqLowLevelIo> TDaqFile;
    typedef struct TStats{
        TIntVec drops;
        TIntVec dropedFrm;
        TIntVec skips;
        TDaqEofStatus eofStat;
    };
    DaqPlayer(int stride = 4);
    bool OpenDaqFile(const std::string &file,TStrVec items);
    bool GotoFrame(int frameNum);
    const TStats& GetStats() {return _stats;}
    virtual void DaqReadProgress(const char *name, int pram1, int param2) {};
    virtual void DaqError(const char *, const char *) {};
    std::string GetLastError() { return m_lastError; };
    bool AddCell(const std::string&);

    template <class T> std::vector<T> GetData(const std::string& name){
        std::vector<T> ret;
        auto idx = _daqNameToIndex.find(name);
        if (idx == _daqNameToIndex.end())
            return ret;
        
        auto index = idx->second;
        auto type = _allDaqChannels[index].GetType();

        int typeSize = sizeof(T);
        if (index >= _daqBuffers.size())
            return ret;
        auto valValueVec = _daqBuffers.at(index);
        auto cnt = valValueVec.GetCount();

        ret.reserve(cnt);
        
        for (size_t i = 0; i < cnt; i++) {
            if (type == "i") {
                ret.push_back((T)valValueVec.GetInt(i));
            }
            else if (type == "s"){
                ret.push_back((T)valValueVec.GetShort(i));
            }
            else if (type == "c") {
                ret.push_back((T)valValueVec.GetChar(i));
            }
            else if (type == "f") {
                ret.push_back((T)valValueVec.GetFloat(i));
            }
            else if (type == "d") {
                ret.push_back((T)valValueVec.GetDouble(i));
            }
        }
        return ret;
    }

private:
    TDaqFile         _pDaqIo;
    TChanInfoVec     _allDaqChannels;
    struct TDifferntialDataFrame {
        TDifferntialDataFrame() :frame(-1) {};
        TDifferntialDataFrame(const TDifferntialDataFrame& in):frame(in.frame), data(in.data) {};
        TDifferntialDataFrame(TDifferntialDataFrame&& in) :frame(in.frame), data(std::move(in.data)) {};
        int frame;
        CDaqBuffer data;
    };
    
    TIntVec          _getDaqChannels;
    CDaqLowLevelIo::TProgressHandlerRef _prog;
    CDaqLowLevelIo::TErrorHandlerRef _error;
    int _stride;
    TStrVec _cellList;
    std::map<std::string,int>  _daqNameToIndex;
    std::vector<CDaqBuffer>  _daqBuffers;
    std::map<std::string, size_t> _nameToChannel;

    TStrVec _varNameList;
    int _DaqFrameRate;
    int _firstFrame;
    int _lastFrame;
    TStats _stats;
    TDaqFile file;
    std::string m_lastError;
};
