#include <string>
#include <vector>
#include <map>
#include <memory>
#include "DaqPlayer.h"
using namespace std;

DaqPlayer::DaqPlayer(int stride):_stride(stride),_firstFrame(-1),_lastFrame(-1) {
}
bool DaqPlayer::OpenDaqFile(const std::string& fileName,TStrVec items) {
    if (_pDaqIo) {
        _pDaqIo.reset();
    }
    _cellList = items;
    string temp;
    _pDaqIo =  std::make_unique<CDaqLowLevelIo>();
    struct stat daqTocInfo;
    //_pDaqIo->SetCallbacks(NULL, &DaqProgressCallBack);
        temp = fileName;
        temp += ".toc";
        //see if we have a .toc file, if not create one
        if (0 != stat(temp.c_str(), &daqTocInfo)) {
            if (!_pDaqIo->Open(fileName)) {
                string message = "Unable to load DAQ file - ";
                message += _pDaqIo->GetLastError();
                _pDaqIo.reset();
                return false;
            }
            if (!_pDaqIo->CheckIntegrity(true, true)) {
                _pDaqIo.reset();
                return false;
            }
        }
        else if (!_pDaqIo->Open(fileName) || !_pDaqIo->TocFileExists()) {
            string message = "Unable to load DAQ file - ";
            message += _pDaqIo->GetLastError();
            return false;
        }
        _pDaqIo->GetChannels(_allDaqChannels);
        _DaqFrameRate = _pDaqIo->GetFrequency();
        if (_DaqFrameRate < 60)
            _DaqFrameRate = 60;
        size_t cnt = 0;
        for (TChanInfoVec::iterator i = _allDaqChannels.begin(); i != _allDaqChannels.end(); i++,cnt++) {
            _varNameList.push_back(i->GetName());
            _nameToChannel[i->GetName()] = cnt;
            for (auto & val : _cellList) {
                if (i->GetName() == val) {
                    _getDaqChannels.push_back(i->GetId());
                    _daqNameToIndex[val] = (int)_getDaqChannels.size() - 1;
                }
            }
        }
        CDaqBuffer empty;
        _daqBuffers.resize(_getDaqChannels.size(), empty);
        TConvertOptions opt = eNO_OPTION;


        opt = opt + eFILL_MISSING;
        _firstFrame =_pDaqIo->GetFirstFrame();
        _lastFrame = _pDaqIo->GetFrames() / (_DaqFrameRate / 60) + _firstFrame;
        //lets see if we have any droped frames



        _pDaqIo->QueryIntegrityValues(
            _stats.drops, _stats.dropedFrm, _stats.skips, _stats.eofStat);

}
bool DaqPlayer::GotoFrame(int frameNum) {
    //DAH this is +3, we are counting by 4's and we are not guarented to have data every 4th frame, although this is true 95% of the time 
    if (!_pDaqIo->GetFullData(&_getDaqChannels, _daqBuffers, eFILL_MISSING, frameNum, frameNum + _stride - 1)) {
        return false;
    }
    return true;
}

bool DaqPlayer::AddCell(const std::string& str) {
    auto itr = _nameToChannel.find(str);
    if (itr == _nameToChannel.end()) {
        return false;
    }
    //see if we have it already
    if (_daqNameToIndex.find(str) == _daqNameToIndex.end())
        return true;
    int id = _allDaqChannels[(itr->second)].GetId();
    _getDaqChannels.push_back(id);
    _daqNameToIndex[str] = _getDaqChannels.size()-1;
    return true; 
    
}