#ifndef _DAQIOLIBDEFINES_H_
#define _DAQIOLIBDEFINES_H_

//////////////////////////////////////////////////////////////////////////////
//
// $Id: DaqIoLibDefines.h,v 1.1 2005/03/14 23:05:05 yiannis Exp $
// Date: March, 2005
// Author: Yiannis Papelis
//
// General definitions for the DAQIO library
//

class CDaqBuffer;
class CDaqChannelInfo;

#define DAQ_MAGIC_NUM_VER_2_0 0x2C3D4E5F
#define DAQ_MAGIC_NUM_VER_2_1 0x2C3D4E6F
#define DAQ_MAGIC_NUM_VER_2_2 0x2C3D4E7F
#define DAQ_END_MARK          0x1A2B2C3D
#define DAQ_TOC_MAGIC_NUM     0x2C3ABCDE

typedef unsigned char       TDaqByte;
typedef vector<int>         TIntVec;
typedef vector<string>      TStrVec;
typedef vector<CDaqBuffer>  TDataVec;
typedef vector<FILE *>      TFileVec;
typedef vector<CDaqChannelInfo> TChanInfoVec;

const int cMaxDaqRec   = 128*1024;   ///< maximum size of data per DAQ record
const int cMaxChannels = 500;       ///< maximum number of channels we can handle
const int cMaxChannResyncLookahead = 2*1024;

///////////////////////////////////////////////////////////////////////////////////
///
/// This enumeration encapsulates various conversion options
/// Appropriate operators have been defined so combining options
/// can be done by using + or |
///
typedef enum {
	eNO_OPTION            = 0,
	eEXPAND_DIFFERENTIAL  = 1,      
	eFILL_MISSING         = 2,      
	eINCLUDE_FRAME        = 4,     
	eBINARY_FORMAT        = 32,     
	eASCII_FORMAT         = 64
} TConvertOptions;

inline TConvertOptions
operator+(TConvertOptions left, TConvertOptions right) {
	return (TConvertOptions)((int)left + (int)right);
}

inline TConvertOptions
operator|(TConvertOptions left, TConvertOptions right) {
	return (TConvertOptions)((int)left | (int)right);
}

///////////////////////////////////////////////////////////////////////////////////////////
///
/// Return code used to specify the status of the end marker of the DAQ file
///
typedef enum {
	eDAQ_EOF_OK = 0,			///< Found full EOF marker
	eDAQ_EOF_PARTIAL_MARK = 1,	///< Found a partial marker
	eDAQ_EOF_NOTFOUND = 2,		///< No EOF marker found
	eDAQ_EOF_UNDEFINED = 3		///< No information available yet
} TDaqEofStatus;


#endif // 