#include <stdio.h>
#include <string>
#include <vector>
#include <map>

using namespace std;


#define DAQ_MAGIC_NUM_VER_2_0 0x2C3D4E5F
#define DAQ_MAGIC_NUM_VER_2_1 0x2C3D4E6F
#define DAQ_MAGIC_NUM_VER_2_2 0x2C3D4E7F
#define DAQ_END_MARK          0x1A2B2C3D


//
// This class represents all information about a channel stored in the DAQ
// file.
//
class CDaqChannelInfo {
public:
	CDaqChannelInfo() {
		m_Id = m_Items = m_CapRate = m_Type = -1;
		m_VarLen = false;
		m_Name = "";
	}
	~CDaqChannelInfo() {};

	int		m_Id;
	int		m_Items;
	string	m_Name;
	int		m_CapRate;
	int		m_Type;
	bool	m_VarLen;
};


/////////////////////////////////////////////////////////////////////////////
//
// This class provides an API that does low level reading from a DAQ file
//
//
class CDaqLowLevelIo {
public:
	CDaqLowLevelIo();
	~CDaqLowLevelIo();

	bool Open(const string &);

private:

	bool ReadHeader(FILE *);
	bool ReadChannelInfo(FILE *);

	string    m_Title;			// As stored in DAQ file
	string    m_Date;			// As stored in DAQ file
	string    m_Subj;			// As stored in DAQ file
	string    m_Run;			// As stored in DAQ file
	string    m_RunInst;		// As stored in DAQ file
	int       m_NumEntries;		// As stored in DAQ file
	int       m_Frequency;		// As stored in DAQ file

	vector<CDaqChannelInfo>	m_Channels;		// Channel information
	long					m_DataOffset;	// where data starts in the file 
	map<int, int>			m_Toc;			// given a sim frame, gives the offset in the file
};
